# Caveats: DUP packets are treated as missing packets, although they may not
# be that.  Not sure what the correct handling is in that case.

MSGSIZE = '64' # Ping message size in bytes
END_MARKER = 'end_of_trace'

  
class Ping:

    def __init__(self, f, verbose=0):
        self.f = f
        self.verbose = verbose

    def traverse_file(self):
        timer = 0.0
        lastseq = -1
        outage = 0
        lost = 0
        seq_add = 0
        outage_table = {}

        l = self.f.readline()
        while l:
            l = self.f.readline()
            # If the string length is less than 2 bytes, ignore line
            if len(l) >= 2:
                # Check if the ping has restarted, if so reset sequence counter
                if l[:4] == 'PING':
                    if self.verbose:
                        print '** Warning: Resetting at sequence number %d' % lastseq
                    seq_add += lastseq
                    lastseq = -1
                    continue
                # Check if this is a line with a ping value, if not continue loop
                if l[:2] != MSGSIZE:  continue
                # Find the string index where the interesting stuff is
                idx = l.find(':') + 2
                # Extract and convert sequence number, latency, etc. 
                tmp = l[idx:].split(' ')
                try:
                    seq, time = int(tmp[0][9:]), float(tmp[2][5:])
                except:
                    if self.verbose:
                        print '** Warning: unable to parse (bogus?) line %s in trace' % repr(l)
                    continue
                # Find if we're missing a packet (DUP packets are treated as misses)
                if seq != lastseq + 1:
                    # Each packet loss corresponds to 60 secs of outage
                    missing = seq - lastseq - 1
                    if self.verbose:
                        print 'Outage (%d secs) from %d to %d' % \
                              (missing * 60, (lastseq + seq_add + 1) * 60,
                               (seq_add + seq) * 60)
                    lost = lost + missing
                    outage = outage + (60 * missing)
                    # Store outage information
                    for x in range((lastseq + seq_add + 1) * 60, seq * 60, 60):
                        outage_table[x] = time

                # Set the last sequence number to the current one
                lastseq = seq

        # Store the sequence number where the trace ends
        outage_table[END_MARKER] = max(0, lastseq) * 60
        
        # Print some stats in the end
        if self.verbose:
            lastseq += seq_add # In case we had some restarts
            if seq_add != 0:
                print '** Warning: ping was restarted during trace, outage results are likely to be inaccurate!'
            print 'Total time (in secs):', lastseq*60
            print 'Total outage time (in secs):', outage
            print 'Outage percentage: %.2f' % ((float(outage)/(lastseq*60)) * 100)
            print 'Total number of lost packets:', lost

        return outage_table


if __name__ == "__main__":
    import sys
    try:
        f = open(sys.argv[1])
    except:
        print 'Usage: %s <ping tracefile>' % sys.argv[0]
        raise SystemExit

    files = f.readlines()
    for f in files:
        print f
        p = Ping(open(f[:-1]), verbose=1)
        p.traverse_file()
