import  sys

LINK_UP = 3
LINK_DOWN = 0
TIMESLICE = 300


# Checking if the trace file is specified
if  len(sys.argv) < 4:
    print  "Usage: python gen_view.py <RON tracefile> <output file> <hostfile> "
    raise SystemExit
tracefile = open(sys.argv[1], "r")
viewfile = open(sys.argv[2], "w")
hostfile = open(sys.argv[3], "r")
trace_hosts = filter(None, hostfile.read().split('\n'))


# Setting the initialized value
grpview = {}
oldview = {0: {0: 'connect', 1: trace_hosts}}
k1 = 0
while  k1 < len(oldview[0][1]) - 1 :
    k2 = k1 + 1
    while  k2  < len(oldview[0][1]) :
        if  oldview[0][1][k1] > oldview[0][1][k2] :
            tmp = oldview[0][1][k1]
            oldview[0][1][k1] = oldview[0][1][k2]
            oldview[0][1][k2] = tmp
        k2 += 1
    k1 += 1

hosts = {}
probe = {}
count = 0
viewstart_time = 0.0
viewfile.write(str(viewstart_time)+'\t'+oldview[0][0]+'\t')


# Initiate "hosts". Every link is set as up at the beginning
for  src  in trace_hosts :
    hosts[src] = {}
    probe[src] = {}
    for dst  in  trace_hosts :
        if  dst != src :
            hosts[src][dst] = LINK_UP
            probe[src][dst] = 0.0


# Read the tracefile line by line, and generate the trace of views
line = tracefile.readline()
line = line.rstrip()
src, dst, ron, s1, r1, s2, r2 = line.split('\t')
start_time = float(s1)


while 1:
    # Reading a line, and check if the end of the file is reached
    line = tracefile.readline()
    if  not line:
        viewfile.write(str(current_tick-viewstart_time)+'\n')
        tracefile.close()
        viewfile.close()
        hostfile.close()
        raise SystemExit

    line = line.rstrip()
    if len(line) == 0 :
        continue
    src, dst, ron, s1, r1, s2, r2 = line.split('\t')
    if not (dst in trace_hosts) :
        continue
    if not (src in trace_hosts) :
        continue

    # Updating the network connections according to this line's information
    if  int(ron) == 0:
        if r1 == "0":
            if hosts[src][dst] > LINK_DOWN :
                hosts[src][dst] -= 1
        else:
            hosts[src][dst] = LINK_UP

        if  r2 == "0":
            if hosts[dst][src] > LINK_DOWN :
                hosts[dst][src] -= 1
        else:
            hosts[dst][src] = LINK_UP

        probe[src][dst] = float(s1) - start_time

    else :
        continue

    # Updating the view according to the new connection
    # The view is initialized as several groups containing a single host

    current_tick = float(s1) - start_time

    grpview = {}
    view_index = 0
    buffer = []
    rest_set = []
    for  anyhost in trace_hosts :
        alive = 0
        for  destination  in trace_hosts :
            if destination == anyhost :
                continue
            if  current_tick - probe[anyhost][destination] < TIMESLICE :
                alive = 1
        if  alive == 1 :
            rest_set.append(anyhost)


    while rest_set != [] :
        start_node = rest_set[0]
        buffer.append(rest_set[0])
        rest_set.remove(start_node)
        grpview[view_index] = {0: 'connect', 1: [start_node]}

        while buffer != [] :
            cur_node = buffer[0]
            for  out_node  in  rest_set :
                if (hosts[cur_node][out_node]>LINK_DOWN) or (hosts[out_node][cur_node]>LINK_DOWN) :
                    buffer.append(out_node)
                    rest_set.remove(out_node)
                    grpview[view_index][1].append(out_node)
            buffer.remove(cur_node)
        view_index += 1
        
    for   g  in  grpview.keys() :
        k1 = 0
        while  k1 < len(grpview[g][1]) - 1 :
            k2 = k1 + 1
            while  k2  < len(grpview[g][1]) :
                if  grpview[g][1][k1] > grpview[g][1][k2] :
                    tmp = grpview[g][1][k1]
                    grpview[g][1][k1] = grpview[g][1][k2]
                    grpview[g][1][k2] = tmp
                k2 += 1
            k1 += 1

                
    # Check if there is an obsolete group in the view
    for  i  in  grpview.keys() :
        for  a in grpview[i][1] :
            for  b in grpview[i][1] :
                if  a == b :
                    continue
                if  (hosts[a][b] == LINK_DOWN) or (hosts[b][a] == LINK_DOWN) :
                    grpview[i][0] = "obsolete"


    if  grpview != oldview :
        viewfile.write(str(current_tick-viewstart_time)+'\n')
        if  (len(grpview) == 1) and (len(grpview[0][1]) == 16) :
            viewfile.write(str(current_tick)+'\t'+grpview[0][0]+'\t')
        else :
            viewfile.write(str(current_tick)+'\t'+str(grpview)+'\t')
        viewstart_time = current_tick
        oldview = grpview
        
     

    # print the number of lines that have been read
    count += 1
    if  count % 10000 == 0 :
        print  count
