####################################
# Setting the values of constants  #
####################################
TASK_UNDONE = 0
TASK_COMPLETED = 1
NO_TASK = -1


####################################
# Define some functions of workers #
####################################
class Host:
    # Initializing some attributes of the worker
    def __init__(self, name, i, task, workers_per_lan):
        self.host_id = trace_hosts.index(name) * workers_per_lan + i
        self.lan = name
        self.local_id = i
        self.group = []
        self.global_id = self.host_id
        self.num_tasks = task
        self.wq = [TASK_UNDONE] * self.num_tasks
        self.completed = []
        self.undone = []
        for  i in range(self.num_tasks) :
            self.undone.append(i)
        self.finished = 0
        self.total = 0
        self.clock = 0.0
        self.workers_per_lan = workers_per_lan
        self.current = NO_TASK

    # Updating the group ID of the workers according to the new view
    def update(self) :
        self.group_id = self.workers_per_lan * self.group.index(self.lan) + self.local_id

    # Choosing a task according to the worker's group ID and undone list
    def pick_task(self):
        if self.group_id < len(self.undone) :
            task_id = self.undone[self.group_id]
            return  task_id
        else :
            task_id = NO_TASK
            return  task_id

    # Running the worker for a round
    def run_worker(self, tick) :
        self.update()
        if  len(self.undone) == 0 :
            self.finished = 1
            self.current = NO_TASK
        else :
            t_id = self.pick_task()
            if  t_id != NO_TASK :
                self.wq[t_id] = TASK_COMPLETED
                self.completed.append(t_id)
                self.undone.remove(t_id)
                self.current = t_id
                self.total += 1
            else :
                self.current = NO_TASK
            self.clock += tick


#######################################
# Checking if the inputs are complete #
#######################################
import sys

if  len(sys.argv) < 8 :
    print "Usage: python ax.py <RON tracefile> <hostfile> <number of tasks> <workers per lan> <dry run time> <time slice> <number of lans>"
    raise SystemExit
tracefile = open(sys.argv[1],"r")
hostfile = open(sys.argv[2], "r")
task = int(sys.argv[3])
workers_per_lan = int(sys.argv[4])
dryrun = float(sys.argv[5])
timeslice = float(sys.argv[6])
num_lan = int(sys.argv[7])
trace_hosts = filter(None, hostfile.read().split('\n'))


###################################################
# Filtering the views before the time of "dryrun" #
###################################################
start_time = 0.0
last_time = 0.0
grpview = {}
while start_time+last_time < dryrun :
    line = tracefile.readline()
    if not line :
        print "Trace file ends before the tick"
        raise SystemExit
    line = line.rstrip()
    t1, view, t2 = line.split('\t')
    start_time = float(t1)
    last_time = float(t2)


#####################################################################
# Initializing num_workers, worker, start_time, last_time, clock... #
#####################################################################
num_workers = num_lan * workers_per_lan
worker = {}
for host in trace_hosts :
    for i in range(workers_per_lan) :
        worker[(host,i)] = Host(host, i, task, workers_per_lan)
last_time = start_time + last_time - dryrun
start_time = dryrun
for w in worker.keys() :
    worker[w].clock = dryrun
clock = start_time
current = 0
terminate = 0
obsotime = 0.0


####################################################
# Simulating the computations under the trace file #
####################################################
while terminate == 0 :

    # Installing the new group view
    grpview = {}
    index = 0
    if view == "obsolete" :
        obsotime += last_time

    if  view == "obsolete" or view == "connect" :
        grpview[0] = [view, trace_hosts]
    else :
        while 1:
            i = view.find("'")
            j = view.find(',')
            status = view[i+1: j-1]
            view = view[j+6:]
            k = view.find(']')
            group = view[0:k]
            group = group.replace("'", "")
            group = group.replace(" ", "")
            grpview[index] = [status, group.split(",")]
            index += 1
            if  view[k+2] == '}' :
                break
            view = view[k+3:]


    for w in worker.keys() :
        for g in grpview.keys() :
            if worker[w].lan in grpview[g][1] :
                worker[w].group = grpview[g][1]

    # Doing appropriate simulation for each group
    for  g  in  grpview.keys() :
        if  grpview[g][0] == "obsolete" :
            for w  in  worker.keys() :
                if  not (worker[w].lan  in grpview[g][1]) :
                    continue
                if  worker[w].finished :
                    continue
                if  worker[w].clock > start_time + last_time :
                    continue
                worker[w].clock = start_time + last_time
        else:
            # If the workers in this group finishing all the work, go to next group
            count = 0
            worker_keys = []
            for w in worker.keys() :
                if not (worker[w].lan in grpview[g][1]) :
                    continue
                worker_keys.append(w)
                if worker[w].finished == 1 :
                    count += 1
            if count == len(grpview[g][1]) * workers_per_lan :
                continue

            # If the synchronization of workers finishes before the next view,
            #     do the computation
            # Otherwise, go to the next group
            clock = dryrun
            for w in worker_keys :
                if worker[w].clock > clock :
                    clock = worker[w].clock

            if  clock < start_time + last_time :
                # Synchronizing the workers in the group
                for w in worker_keys :
                    worker[w].clock = clock

                # Exchanging the states among the workers
                complete = []
                for w in worker_keys :
                    for  current in worker[w].completed :
                        if not (current in complete) :
                            complete.append(current)

                for w in worker_keys :
                    for current in complete :
                        if worker[w].wq[current] != TASK_COMPLETED :
                            worker[w].wq[current] = TASK_COMPLETED
                            worker[w].undone.remove(current)
                            worker[w].completed.append(current)

                # If the workers know all the results, skip other operations
                count = 0
                for  w in worker_keys :
                    if len(worker[w].undone) == 0 :
                        worker[w].finished = 1
                    if worker[w].finished == 1 :
                        count += 1
                if count == len(grpview[g][1]) * workers_per_lan :
                    continue

                # Making the workers running, until a new view or no undone tasks
                finish = 0
                while  finish == 0  and  clock < start_time + last_time :
                    for  w  in worker_keys :
                        worker[w].run_worker(timeslice)

                    clock += timeslice
                    if clock > start_time + last_time :
                        break

                    complete = []
                    for w in worker_keys :
                        if worker[w].current != NO_TASK :
                            complete.append(worker[w].current)

                    for w in worker_keys :
                        for current in complete :
                            if worker[w].wq[current] != TASK_COMPLETED :
                                worker[w].wq[current] = TASK_COMPLETED
                                worker[w].undone.remove(current)
                                worker[w].completed.append(current)

                    for w in worker_keys :
                        if len(worker[w].undone) == 0 :
                            worker[w].finished = 1
                        if worker[w].finished == 1 :
                            finish = 1

    # If computation finished for all the workers, exit the loop
    count = 0
    for w in worker.keys() :
        if worker[w].finished :
            count += 1
    if count == len(worker) :
        terminate = 1

    # Reading the next line of the group view file
    line = tracefile.readline()
    if not line:
        print "trace file ends before the tick"
        raise SystemExit
    line = line.rstrip()
    t1, view, t2 = line.split('\t')
    start_time = float(t1)
    last_time = float(t2) 


########################################################################
# Calculating the value of clock and total_task, and printing results  #
########################################################################
total_task = 0
for w in worker.keys() :
    total_task += worker[w].total
clock = 0.0
for w in worker.keys() :
    if clock < worker[w].clock :
        clock = worker[w].clock
print "Elapsed time (in seconds): ", clock - dryrun
print "Number of tasks: ", task
print "Number of workers: ", num_workers
print "Redundant tasks: ", total_task - task
print "Obsolete time: ", obsotime, '\t', obsotime/(clock-dryrun)
