#######################################
# Checking if the inputs are complete #
#######################################
import sys
import string

if  len(sys.argv) < 3 :
    print "Usage: python analysis.py <RON tracefile> <number of lans>"
    raise SystemExit
tracefile = open(sys.argv[1],"r")
num_lan = int(sys.argv[2])


#####################################################
# Calculating the Computation, Idle, Redundant time #
#####################################################
comp_time = 0.0
idle_time = 0.0
part_time = 0.0
elap_time = 0.0

partition = {}
old_par = {}
doublec = 0.0
par_last = 0.0

while 1 :
    # Reading the next line of the group view file
    line = tracefile.readline()
    if line == '\n':
        break
    line = line.rstrip()
    if len(line) == 0 :
        break
    t1, view, t2 = line.split('\t')
    start_time = float(t1)
    last_time = float(t2)
    elap_time += last_time

    # Installing the new group view
    grpview = {}
    partition = {}
    index = 0
    if  view == "obsolete" or view == "connect" :
        if  view == "obsolete" :
            idle_time += last_time * num_lan
        else :
            comp_time += last_time * num_lan
    else :
        while 1:
            i = view.find("'")
            j = view.find(',')
            status = view[i+1: j-1]
            view = view[j+6:]
            k = view.find(']')
            group = view[0:k]
            group = group.replace("'", "")
            group = group.replace(" ", "")
            grpview[index] = [status, group.split(",")]
            partition[index] = group.split(",")
            index += 1
            if  view[k+2] == '}' :
                break
            view = view[k+3:]

        if  len(grpview) > 1 :
            part_time += last_time

            if  partition != old_par :
                old_par = partition
                par_last = last_time
                doublec = 0
            else :
                par_last += last_time

            if len(grpview) > 2 :
                print "there are more than 2 partitions"
                raise SystemExit
            if  (grpview[0][0] == "connect") and (grpview[1][0] == "connect") :
                doublec += last_time


        for g in grpview.keys() :
            if  grpview[g][0] == "obsolete" :
                idle_time += last_time * len(grpview[g][1])
            else :
                comp_time += last_time * len(grpview[g][1])



##############################
# Printing the final results #
##############################
print "Computation time (in seconds): ", comp_time
print "Idle time (in seconds): ", idle_time
print "Efficiency: ", comp_time / (comp_time + idle_time)
print "Partition time (in seconds): ", part_time
print "Elapsed time (in seconds): ", elap_time
